module htoclean;

import StdEnv;
import fclc;

import htoclean_file;

/* for windows */

import code from "program_args.o";

n_args :: Int;
n_args = code {
	ccall n_args "-I"
}

program_arg :: !Int -> {#Char};
program_arg i = code {
	ccall program_arg "I-S"
}

DirectorySeparator :== '\\';

/* */

/*  old unix code ?
	n_args:==GetArgC;
	program_arg i:==GetArgvN i;
	
	GetArgC :: Int;
	GetArgC = code {
			ccall get_argc ":I"
		}
	
	GetArgvN :: !Int -> String;
	GetArgvN n = code {
			ccall get_argv_n "I:S"
		}

	DirectorySeparator :== '/';
*/

/*	for macintosh

	DirectorySeparator :== ':';
	import mac_file_selector_carbon;

*/

/*  for unix

	import ArgEnv;

	args=:getCommandLine;
	n_args:==size args;
	program_arg i:==args.[i];

	DirectorySeparator :== '/';
*/

split_path_name_in_file_and_directory_name :: !{#Char} -> (!{#Char},{#Char});
split_path_name_in_file_and_directory_name path_name
	# last_directory_separator_index = find_last_directory_separator (size path_name-1);
		with {
			find_last_directory_separator n
				| n<0 || path_name.[n]==DirectorySeparator
					= n;
					= find_last_directory_separator (n-1);
		}
	= (path_name % (0,last_directory_separator_index),path_name % (last_directory_separator_index+1,size path_name-1));

write_errors [] stdio
	= stdio;
write_errors [HError string line:l] stdio
	| line<>0
		# stdio=stdio <<< string <<< " [line:" <<< line <<< "]\n";
		= write_errors l stdio;
		# stdio=stdio <<< string <<< '\n';
		= write_errors l stdio;

wait_for_keypress w
/* for windows and mac */
	# (stdio,w) = stdio w;
	  stdio = stdio <<< "Press any key to exit";
	  (ok,c,stdio) = freadc stdio;
	  (ok,w) = fclose stdio w;
	= w;

Start w
/* not for macintosh */
	# n_arguments=n_args;
	| n_arguments<>2
		# stderr=fwrites "Usage: htoclean h_file_name\n" stderr;
		  stderr=fwrites "Generates a .icl and .dcl file for a c header file\n" stderr;
		  (_,w) = fclose stderr w;
		= wait_for_keypress w;
		# path_name = program_arg 1;
/* */
/* for macintosh
		# (stdio_,w) = stdio w;
	 	  stdio_ = stdio_ <<< "Select the C header file\n";
		  w = force_file_io stdio_ w;
		  (ok,path_name,w) = SelectInputFile w;
*/
	# (ok,path_name,w) = get_path_name w;
	| not ok
		= w;
		# (directory_name,file_name) = split_path_name_in_file_and_directory_name path_name;
		  h_file_name = if (file_name % (size file_name-2,size file_name-1)==".h") (file_name % (0,size file_name-3)) file_name;
		  (errors,w) = accFiles (compile_header directory_name h_file_name) w;
		= case errors of {
			[]	->	w;
			_	# (stdio,w) = stdio w;
		  		  stdio = write_errors errors stdio;
		  		  (_,w) = fclose stdio w;
				-> wait_for_keypress w;
		  };
